
import type { Metadata } from 'next';

export const metadata: Metadata = {
    title: 'Disclaimer | RiteClick Technology',
    description: 'Disclaimer for RiteClick Technology. Information, training, and resources are for educational purposes only.',
};

export default function DisclaimerPage() {
  return (
    <div className="container py-12 md:py-24">
      <article className="prose prose-lg mx-auto max-w-4xl">
        <h1 className="text-3xl md:text-5xl font-bold font-headline mb-8 text-center">Disclaimer</h1>

        <p>
          The information, training, and resources provided by RiteClick Technology and Academy are for educational and informational purposes only. While we strive to ensure accuracy, we do not guarantee specific results or outcomes from the use of our content, services, or training. RiteClick is not liable for any losses, decisions, or actions taken based on the information provided on this website.
        </p>
        <p>
          We are not affiliated with, endorsed by, or partnered with any third-party company unless explicitly stated. Third-party ads or links that appear on our site are not endorsed by RiteClick, and we are not responsible for their content, accuracy, or practices.
        </p>
        <p>
          By using our website, you agree that you do so at your own discretion and responsibility.
        </p>

      </article>
    </div>
  );
}
