
"use client";

import { useState, useEffect } from 'react';
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { useToast } from '@/hooks/use-toast';
import { BarChart, MessageSquare, Sparkles, UploadCloud } from 'lucide-react';
import { useForm, ValidationError } from '@formspree/react';

const features = [
  {
    icon: Sparkles,
    title: 'AI-Powered Posts & Images',
    description: 'Automatically generate engaging Google Business Profile posts and stunning images that capture attention.',
  },
  {
    icon: MessageSquare,
    title: 'Smart Review Responses',
    description: 'Instantly reply to customer reviews with context-aware, AI-generated responses that build loyalty.',
  },
  {
    icon: BarChart,
    title: 'Performance Analytics & Insights',
    description: 'Track your profile’s performance with easy-to-understand dashboards and get actionable insights.',
  },
    {
    icon: UploadCloud,
    title: 'Data Upload & Dashboards',
    description: 'Turn your raw business data into beautiful, interactive dashboards that reveal growth opportunities.',
    },
];

export function BoostlyClientPage() {
    const { toast } = useToast();
    const [state, handleSubmit] = useForm("myzdbnob");
    const [email, setEmail] = useState('');


    useEffect(() => {
        if (state.succeeded) {
            toast({
                title: "You're on the list!",
                description: "Thanks for joining the Boostly waitlist. We'll be in touch soon.",
            });
            setEmail('');
        }
        if (state.errors) {
            toast({
                title: "Error",
                description: "Something went wrong. Please check the form and try again.",
                variant: "destructive",
            });
        }
    }, [state.succeeded, state.errors, toast]);


  return (
    <div className="flex flex-col min-h-screen bg-background">
      {/* Hero Section */}
      <section className="w-full py-20 md:py-32 lg:py-40 bg-secondary">
        <div className="container px-4 md:px-6 text-center">
          <h1 className="text-4xl font-bold tracking-tighter sm:text-5xl md:text-6xl font-headline bg-clip-text text-transparent bg-gradient-to-r from-primary to-accent-foreground">
            Boostly
          </h1>
          <p className="mt-4 max-w-xl mx-auto text-xl text-muted-foreground">
            Boost visibility, boost growth.
          </p>
          <p className="mt-6 max-w-2xl mx-auto text-lg text-muted-foreground/80">
            Boostly automates Google Business Profile posts, replies to reviews with AI, and turns raw data into dashboards that drive business growth.
          </p>
          <div className="mt-8">
            <Button size="lg" asChild>
              <a href="#early-access">
                Join the Waitlist
              </a>
            </Button>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section id="features" className="w-full py-12 md:py-24 lg:py-32">
        <div className="container px-4 md:px-6">
          <div className="text-center">
            <h2 className="text-3xl font-bold tracking-tighter sm:text-4xl font-headline">Powerful Features, Simple Interface</h2>
            <p className="max-w-2xl mx-auto mt-4 text-muted-foreground md:text-xl">
              Everything you need to put your local marketing on autopilot.
            </p>
          </div>
          <div className="mx-auto grid grid-cols-1 gap-8 py-12 sm:grid-cols-2">
            {features.map((feature, index) => {
                const Icon = feature.icon;
                return (
                    <Card key={index} className="flex flex-col transition-transform transform hover:-translate-y-2">
                        <CardHeader>
                            <div className="flex items-center gap-4">
                                <div className="bg-primary/10 rounded-full p-3 w-fit">
                                    <Icon className="h-8 w-8 text-primary" />
                                </div>
                                <CardTitle className="font-headline text-2xl">{feature.title}</CardTitle>
                            </div>
                        </CardHeader>
                        <CardContent>
                            <p className="text-muted-foreground">{feature.description}</p>
                        </CardContent>
                    </Card>
                )
            })}
          </div>
        </div>
      </section>

      {/* Pricing Teaser */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-secondary">
        <div className="container px-4 md:px-6 text-center">
          <h2 className="text-3xl font-bold tracking-tighter sm:text-4xl font-headline">Simple, Transparent Pricing</h2>
          <p className="mt-4 max-w-xl mx-auto text-xl text-muted-foreground">
            Flexible, performance-based pricing. Pay for results, not software.
          </p>
           <div className="mt-8">
            <Button size="lg" variant="outline" asChild>
              <a href="#early-access">
                Join the Waitlist
              </a>
            </Button>
          </div>
        </div>
      </section>

      {/* Early Access Section */}
      <section id="early-access" className="w-full py-12 md:py-24 lg:py-32 bg-background">
        <div className="container px-4 md:px-6">
          <div className="max-w-2xl mx-auto text-center">
            <h2 className="text-3xl font-bold tracking-tighter sm:text-4xl font-headline">Get Early Access to Boostly</h2>
            <p className="mt-4 text-muted-foreground">
              Be the first to know when we launch. Join our waitlist for exclusive updates and early bird pricing.
            </p>
            <form onSubmit={handleSubmit} className="mt-8 flex flex-col sm:flex-row gap-4 max-w-md mx-auto">
              <Input
                id="email"
                type="email"
                name="email"
                placeholder="Enter your email"
                className="flex-1"
                value={email}
                onChange={(e) => setEmail(e.target.value)}
                required
                disabled={state.submitting}
              />
               <ValidationError 
                prefix="Email" 
                field="email"
                errors={state.errors}
                className="text-destructive text-sm mt-1"
              />
              <Button type="submit" disabled={state.submitting}>
                {state.submitting ? 'Joining...' : 'Join Waitlist'}
              </Button>
            </form>
          </div>
        </div>
      </section>
    </div>
  );
}
