
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Check, BrainCircuit, Bot, TrendingUp, Sparkles, Layers, ThumbsUp, MessageCircle, Link as LinkIcon } from 'lucide-react';
import Image from 'next/image';
import type { Metadata } from 'next';
import Link from 'next/link';


export const metadata: Metadata = {
    title: 'AI Development Services | RiteClick Technology',
    description: 'Expert AI development services including chatbots, generative AI, predictive models, agentic systems, machine learning, deep learning, and recommendation systems.',
};

const services = [
  {
    title: 'Generative AI Solutions',
    description: 'Harness the power of large language models to create intelligent content, automate workflows, and build innovative applications with our expertise in Generative AI.',
    icon: Sparkles,
    features: ['Custom LLM Fine-tuning', 'Content Generation & Summarization', 'Image & Data Synthesis', 'RAG (Retrieval-Augmented Generation)'],
  },
  {
    title: 'Intelligent Chatbot Development',
    description: 'Build smart, conversational chatbots and virtual assistants for customer support, lead generation, and user engagement using the latest NLP technologies.',
    icon: Bot,
    features: ['24/7 Customer Support Bots', 'Lead Qualification Bots', 'Internal Helpdesk Assistants', 'Omnichannel Integration'],
  },
  {
    title: 'Predictive Analytics & Forecasting',
    description: 'Leverage machine learning to analyze historical data and make accurate predictions about future trends, customer behavior, and business outcomes.',
    icon: TrendingUp,
    features: ['Demand Forecasting', 'Customer Churn Prediction', 'Predictive Maintenance', 'Fraud Detection'],
  },
  {
    title: 'Machine Learning & Deep Learning',
    description: 'Develop custom machine learning and deep learning models to solve complex business problems, from computer vision to natural language understanding.',
    icon: BrainCircuit,
    features: ['Custom Model Development', 'Computer Vision Systems', 'Natural Language Processing (NLP)', 'Anomaly Detection Models'],
  },
  {
    title: 'Agentic AI Systems',
    description: 'Design and deploy autonomous AI agents that can perform complex tasks, reason through problems, and interact with various systems to achieve goals.',
    icon: Layers,
    features: ['Automated Workflows', 'Goal-Oriented Task Execution', 'Tool & API Integration', 'Multi-Agent Systems'],
  },
  {
    title: 'Recommendation Systems',
    description: 'Increase engagement and sales with personalized recommendation engines that suggest relevant products, content, or services to your users.',
    icon: ThumbsUp,
    features: ['Personalized Product Recommendations', 'Content Discovery Engines', 'Collaborative & Content-Based Filtering', 'Real-time Suggestions'],
  },
];

export default function AIDevelopmentPage() {
  return (
    <div className="flex flex-col min-h-screen">
      {/* Hero Section */}
      <section className="relative w-full py-20 md:py-32 lg:py-40 flex items-center justify-center text-center text-white">
        <Image
          src="/aidev.png"
          alt="AI Development"
          fill
          priority
          className="object-cover -z-10 brightness-50"
        />
        <div className="container px-4 md:px-6">
          <div className="flex flex-col items-center space-y-4">
            <h1 className="text-4xl font-bold tracking-tighter sm:text-5xl xl:text-6xl/none font-headline">
              AI Development Services
            </h1>
            <p className="max-w-[700px] text-lg md:text-xl">
              Building intelligent solutions that drive innovation. We turn complex data into business value with cutting-edge AI.
            </p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-secondary">
        <div className="container px-4 md:px-6">
          <div className="text-center">
            <h2 className="text-3xl font-bold tracking-tighter sm:text-5xl font-headline">Our AI & Machine Learning Services</h2>
            <p className="max-w-[900px] mx-auto text-muted-foreground md:text-xl/relaxed mt-4">
              From chatbots to complex deep learning models, we provide end-to-end AI solutions to give your business a competitive edge.
            </p>
          </div>
          <div className="mx-auto grid grid-cols-1 gap-8 py-12 sm:grid-cols-2 lg:grid-cols-3">
            {services.map((service, index) => {
              const Icon = service.icon;
              return (
                <Card key={index} className="flex flex-col transition-transform transform hover:-translate-y-2">
                  <CardHeader>
                    <div className="flex items-center gap-4">
                      <div className="bg-primary/10 rounded-full p-3 w-fit">
                        <Icon className="h-8 w-8 text-primary" />
                      </div>
                      <CardTitle className="font-headline text-2xl">{service.title}</CardTitle>
                    </div>
                  </CardHeader>
                  <CardContent className="flex-grow flex flex-col">
                    <p className="text-muted-foreground mb-6">{service.description}</p>
                    <ul className="space-y-3 flex-grow">
                      {service.features.map((feature, fIndex) => (
                         <li key={fIndex} className="flex items-start gap-3">
                            <Check className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                            <span className="text-muted-foreground">{feature}</span>
                        </li>
                      ))}
                    </ul>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-background">
        <div className="container text-center">
            <h2 className="text-3xl md:text-4xl font-bold font-headline">Ready to Innovate with AI?</h2>
            <p className="mt-4 max-w-2xl mx-auto text-muted-foreground">
              Let's explore how AI can transform your business. Contact us for a consultation with our AI specialists.
            </p>
            <div className="mt-8 flex flex-col sm:flex-row items-center justify-center gap-4">
                <Button size="lg" asChild>
                  <Link href="https://calendly.com/riteclick/new-meeting" target="_blank" rel="noopener noreferrer">
                    Schedule a Free Consultation <LinkIcon className="ml-2" />
                  </Link>
                </Button>
                <Button size="lg" variant="outline" asChild>
                    <a href="https://wa.me/2349115572489" target="_blank" rel="noopener noreferrer">
                        <MessageCircle className="mr-2" /> Chat on WhatsApp
                    </a>
                </Button>
            </div>
        </div>
      </section>
    </div>
  );
}
