
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { CheckCircle } from 'lucide-react';
import Link from 'next/link';
import type { Metadata } from 'next';

export const metadata: Metadata = {
    title: 'Thank You for Your Enrollment | RiteClick Technology',
    description: 'Your payment has been successfully processed. Welcome to RiteClick Technology!',
};

export default function ThankYouPage() {
  return (
    <div className="container flex items-center justify-center py-24 md:py-32">
      <Card className="max-w-lg text-center shadow-lg">
        <CardHeader>
          <div className="mx-auto bg-green-100 rounded-full p-4 w-fit mb-4">
            <CheckCircle className="w-12 h-12 text-green-600"/>
          </div>
          <CardTitle className="text-3xl font-headline">Thank You!</CardTitle>
        </CardHeader>
        <CardContent className="space-y-6">
          <p className="text-muted-foreground">
            Your enrollment has been confirmed. We are thrilled to have you join us! You will receive an email shortly with the next steps.
          </p>
          <Button asChild size="lg">
            <Link href="/#courses">
              Back to Courses
            </Link>
          </Button>
        </CardContent>
      </Card>
    </div>
  );
}
