
"use client";

import { useState, useEffect } from 'react';
import { Button } from '@/components/ui/button';
import { Card } from '@/components/ui/card';
import Link from 'next/link';

export function CookieConsent() {
  const [showConsent, setShowConsent] = useState(false);

  useEffect(() => {
    // We can't check localStorage on the server, so we do it in useEffect.
    const consent = localStorage.getItem('cookie_consent');
    if (consent === null) {
      setShowConsent(true);
    }
  }, []);

  const acceptCookie = () => {
    localStorage.setItem('cookie_consent', 'true');
    setShowConsent(false);
    // You would typically initialize analytics here or on the next page load.
    // For example: window.gtag('consent', 'update', { 'analytics_storage': 'granted' });
  };

  const declineCookie = () => {
    localStorage.setItem('cookie_consent', 'false');
    setShowConsent(false);
  };

  if (!showConsent) {
    return null;
  }

  return (
    <Card className="fixed bottom-4 left-4 z-[100] w-full max-w-md p-4 shadow-2xl animate-in slide-in-from-bottom-10">
      <div className="flex flex-col gap-4">
        <div>
          <h3 className="font-semibold">Cookie Preferences</h3>
          <p className="text-sm text-muted-foreground mt-1">
            We use cookies to enhance your browsing experience and analyze site traffic. By clicking "Accept", you consent to our use of cookies.
            Read our <Link href="/privacy-policy" className="underline hover:text-primary">Privacy Policy</Link> for more details.
          </p>
        </div>
        <div className="flex justify-end gap-2">
          <Button variant="outline" onClick={declineCookie}>
            Decline
          </Button>
          <Button onClick={acceptCookie}>
            Accept
          </Button>
        </div>
      </div>
    </Card>
  );
}
