
import Link from "next/link";
import { Logo } from "@/components/logo";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Github, Twitter, MessageCircle } from "lucide-react";

export function Footer() {
  return (
    <footer className="w-full py-12 bg-secondary">
      <div className="container grid grid-cols-1 md:grid-cols-4 gap-8">
        <div className="flex flex-col gap-4">
          <Link href="/">
            <Logo />
          </Link>
          <p className="text-sm text-muted-foreground">
            Bringing your ideas to life with robust, scalable, and user-friendly web solutions.
          </p>
        </div>

        <div className="flex flex-col gap-2">
          <h3 className="font-semibold text-foreground">Quick Links</h3>
          <Link href="/" className="text-sm text-muted-foreground hover:text-primary">Home</Link>
          <Link href="/services/software-development" className="text-sm text-muted-foreground hover:text-primary">Services</Link>
          <Link href="/privacy-policy" className="text-sm text-muted-foreground hover:text-primary">Privacy Policy</Link>
          <Link href="/terms-of-use" className="text-sm text-muted-foreground hover:text-primary">Terms of Use</Link>
          <Link href="/disclaimer" className="text-sm text-muted-foreground hover:text-primary">Disclaimer</Link>
        </div>
        
        <div className="flex flex-col gap-2">
            <h3 className="font-semibold text-foreground">Courses</h3>
            <Link href="/courses/cloud-computing" className="text-sm text-muted-foreground hover:text-primary">Cloud Computing</Link>
            <Link href="/courses/data-science-ai" className="text-sm text-muted-foreground hover:text-primary">Data Science & AI</Link>
            <Link href="/courses/data-analysis" className="text-sm text-muted-foreground hover:text-primary">Data Analysis</Link>
            <Link href="/courses/cyber-security" className="text-sm text-muted-foreground hover:text-primary">Cyber Security</Link>
        </div>

        <div className="flex flex-col gap-4">
          <h3 className="font-semibold text-foreground">Stay Connected</h3>
          <p className="text-sm text-muted-foreground">Join our WhatsApp group for updates and support.</p>
          <div className="flex gap-2">
            <Button asChild>
              <a href="https://wa.me/2349115572489" target="_blank" rel="noopener noreferrer">
                <MessageCircle className="w-4 h-4 mr-2" /> WhatsApp
              </a>
            </Button>
          </div>
        </div>
      </div>
      <div className="container mt-8 text-center text-sm text-muted-foreground">
        © {new Date().getFullYear()} RiteClick Technology. All rights reserved.
      </div>
    </footer>
  );
}
