
"use client";

import Link from "next/link";
import {
  NavigationMenu,
  NavigationMenuContent,
  NavigationMenuItem,
  NavigationMenuLink,
  NavigationMenuList,
  NavigationMenuTrigger,
  navigationMenuTriggerStyle,
} from "@/components/ui/navigation-menu";
import { Button } from "@/components/ui/button";
import { Sheet, SheetContent, SheetTrigger } from "@/components/ui/sheet";
import { Menu, BookOpen, BrainCircuit, Cloud, ShieldCheck, Facebook, Youtube, Instagram, Linkedin, Code, BarChart3, Megaphone, Activity, Cloudy, Bot, Rocket } from "lucide-react";
import { Logo } from "@/components/logo";
import { courses } from "@/lib/courses";
import React from "react";
import { cn } from "@/lib/utils";

const courseIconMap: { [key: string]: React.ElementType } = {
  'cloud-computing': Cloud,
  'data-science-ai': BrainCircuit,
  'data-analysis': BookOpen,
  'cyber-security': ShieldCheck,
};

const services = [
    {
        title: "Software Development",
        slug: "software-development",
        description: "Custom web and mobile application development.",
        icon: Code,
    },
    {
        title: "Cloud Consultancy",
        slug: "cloud-consultancy",
        description: "Expert guidance for AWS, GCP, and Azure.",
        icon: Cloudy,
    },
    {
        title: "AI Development",
        slug: "ai-development",
        description: "Build intelligent solutions that drive innovation.",
        icon: Bot,
    },
    {
        title: "Data Analytics Consultancy",
        slug: "data-analytics-consultancy",
        description: "Unlock insights and drive decisions with data.",
        icon: BarChart3,
    },
    {
        title: "Digital Marketing Consultancy",
        slug: "digital-marketing-consultancy",
        description: "Grow your brand with data-driven marketing.",
        icon: Megaphone,
    },
    {
        title: "Digital Analytics Consultancy",
        slug: "digital-analytics-consultancy",
        description: "Track, measure, and optimize your website performance.",
        icon: Activity,
    }
];

const products = [
    {
        title: "Boostly",
        slug: "products/boostly",
        description: "Automate your Google Business Profile and boost growth.",
        icon: Rocket
    }
]

export function Header() {
  const [isOpen, setIsOpen] = React.useState(false);

  return (
    <header className="sticky top-0 z-50 w-full border-b bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60">
      <div className="container flex h-14 items-center">
        <div className="mr-4 hidden md:flex">
          <Link href="/" className="mr-6 flex items-center space-x-2">
            <Logo />
          </Link>
          <nav className="flex items-center space-x-6 text-sm font-medium">
            <NavigationMenu>
              <NavigationMenuList>
                <NavigationMenuItem>
                  <Link href="/" asChild>
                    <NavigationMenuLink className={navigationMenuTriggerStyle()}>
                      Home
                    </NavigationMenuLink>
                  </Link>
                </NavigationMenuItem>
                <NavigationMenuItem>
                  <NavigationMenuTrigger>Courses</NavigationMenuTrigger>
                  <NavigationMenuContent>
                    <ul className="grid w-[400px] gap-3 p-4 md:w-[500px] md:grid-cols-2 lg:w-[600px] ">
                      {courses.map((course) => {
                        const Icon = courseIconMap[course.slug];
                        return (
                          <ListItem
                            key={course.title}
                            title={course.title}
                            href={`/courses/${course.slug}`}
                          >
                            <div className="flex items-start">
                              {Icon && <Icon className="h-6 w-6 mr-3 text-primary" />}
                              <span>{course.tagline}</span>
                            </div>
                          </ListItem>
                        );
                      })}
                    </ul>
                  </NavigationMenuContent>
                </NavigationMenuItem>
                 <NavigationMenuItem>
                  <NavigationMenuTrigger>Services</NavigationMenuTrigger>
                  <NavigationMenuContent>
                    <ul className="grid w-[400px] gap-3 p-4 md:w-[500px] md:grid-cols-2 lg:w-[600px] ">
                      {services.map((service) => {
                        const Icon = service.icon;
                        return (
                          <ListItem
                            key={service.title}
                            title={service.title}
                            href={`/services/${service.slug}`}
                          >
                            <div className="flex items-start">
                              {Icon && <Icon className="h-6 w-6 mr-3 text-primary" />}
                              <span>{service.description}</span>
                            </div>
                          </ListItem>
                        );
                      })}
                    </ul>
                  </NavigationMenuContent>
                </NavigationMenuItem>
                <NavigationMenuItem>
                  <NavigationMenuTrigger>Products</NavigationMenuTrigger>
                  <NavigationMenuContent>
                    <ul className="grid w-[400px] gap-3 p-4 md:w-[500px] lg:w-[300px]">
                      {products.map((product) => {
                        const Icon = product.icon;
                        return (
                          <ListItem
                            key={product.title}
                            title={product.title}
                            href={`/${product.slug}`}
                          >
                            <div className="flex items-start">
                              {Icon && <Icon className="h-6 w-6 mr-3 text-primary" />}
                              <span>{product.description}</span>
                            </div>
                          </ListItem>
                        );
                      })}
                    </ul>
                  </NavigationMenuContent>
                </NavigationMenuItem>
              </NavigationMenuList>
            </NavigationMenu>
          </nav>
        </div>
        
        {/* Mobile Menu */}
        <div className="md:hidden">
          <Sheet open={isOpen} onOpenChange={setIsOpen}>
            <SheetTrigger asChild>
              <Button
                variant="ghost"
                className="px-0 text-base hover:bg-transparent focus-visible:bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0"
              >
                <Menu className="h-6 w-6" />
                <span className="sr-only">Toggle Menu</span>
              </Button>
            </SheetTrigger>
            <SheetContent side="left" className="pr-0">
              <Link href="/" className="flex items-center" onClick={() => setIsOpen(false)}>
                <Logo />
              </Link>
              <div className="my-4 h-[calc(100vh-8rem)] pb-10 pl-6">
                <div className="flex flex-col space-y-3">
                  <Link href="/" className="text-lg" onClick={() => setIsOpen(false)}>Home</Link>
                  <span className="text-lg font-semibold">Courses</span>
                  {courses.map((course) => (
                    <Link
                      key={course.slug}
                      href={`/courses/${course.slug}`}
                      className="text-muted-foreground"
                      onClick={() => setIsOpen(false)}
                    >
                      {course.title}
                    </Link>
                  ))}
                   <span className="text-lg font-semibold pt-4">Services</span>
                  {services.map((service) => (
                    <Link
                      key={service.slug}
                      href={`/services/${service.slug}`}
                      className="text-muted-foreground"
                      onClick={() => setIsOpen(false)}
                    >
                      {service.title}
                    </Link>
                  ))}
                  <span className="text-lg font-semibold pt-4">Products</span>
                  {products.map((product) => (
                    <Link
                      key={product.slug}
                      href={`/${product.slug}`}
                      className="text-muted-foreground"
                      onClick={() => setIsOpen(false)}
                    >
                      {product.title}
                    </Link>
                  ))}
                </div>
              </div>
            </SheetContent>
          </Sheet>
        </div>
        <div className="flex flex-1 items-center justify-between space-x-2 md:justify-end">
          <div className="md:hidden">
            <Link href="/">
              <Logo />
            </Link>
          </div>
          <div className="flex items-center gap-4">
              <div className="hidden md:flex items-center gap-2">
                <a href="https://www.facebook.com/people/Rite-Click/61567384802753/" target="_blank" rel="noopener noreferrer"><Facebook className="h-5 w-5 text-muted-foreground hover:text-primary"/></a>
                <a href="https://www.youtube.com/@Rite_Click" target="_blank" rel="noopener noreferrer"><Youtube className="h-5 w-5 text-muted-foreground hover:text-primary"/></a>
                <a href="#" target="_blank" rel="noopener noreferrer"><Instagram className="h-5 w-5 text-muted-foreground hover:text-primary"/></a>
                <a href="https://www.linkedin.com/company/76809885/" target="_blank" rel="noopener noreferrer"><Linkedin className="h-5 w-5 text-muted-foreground hover:text-primary"/></a>
              </div>
            
            <Button asChild>
              <a href="https://riteclick.trainercentralsite.com/" target="_blank" rel="noopener noreferrer">
                Academy
              </a>
            </Button>
          </div>
        </div>
      </div>
    </header>
  );
}

const ListItem = React.forwardRef<
  React.ElementRef<"a">,
  React.ComponentPropsWithoutRef<"a">
>(({ className, title, children, href, ...props }, ref) => {
  return (
    <li>
      <NavigationMenuLink asChild>
        <Link
          href={href!}
          ref={ref}
          className={cn(
            "block select-none space-y-1 rounded-md p-3 leading-none no-underline outline-none transition-colors hover:bg-accent hover:text-accent-foreground focus:bg-accent focus:text-accent-foreground",
            className
          )}
          {...props}
        >
          <div className="text-sm font-medium leading-none">{title}</div>
          <p className="line-clamp-2 text-sm leading-snug text-muted-foreground">
            {children}
          </p>
        </Link>
      </NavigationMenuLink>
    </li>
  );
});
ListItem.displayName = "ListItem";
