
export type Curriculum = {
  weeks: string;
  title: string;
  topics: string[];
};

export type Testimonial = {
  name: string;
  role: string;
  quote: string;
  avatar: string;
};

export type Course = {
  slug: string;
  title: string;
  tagline: string;
  price: string;
  whatsAppLink: string;
  paymentLink: string;
  about: {
    duration: string;
    format: string;
    level: string;
    platform: string;
    certificate: string;
  };
  learnItems: string[];
  benefits: { title: string; description: string }[];
  testimonials: Testimonial[];
  curriculum: Curriculum[];
};

export const courses: Course[] = [
  {
    slug: 'cloud-computing',
    title: 'Cloud Computing',
    tagline: 'Master in 3 Months — Beginner-Friendly & Career-Oriented',
    price: '150,000',
    whatsAppLink: 'https://chat.whatsapp.com/CFfsx6neSvN2Po7SWowDrL',
    paymentLink: 'https://paystack.shop/pay/aws-cloud',
    about: {
      duration: '3 months',
      format: 'Virtual',
      level: 'Beginner-friendly',
      platform: 'Telegram live',
      certificate: 'Certificate of Completion',
    },
    learnItems: [
      'Fundamentals of AWS, GCP, and Azure.',
      'Core concepts of virtualization, storage, and networking.',
      'Deploying and managing applications on the cloud.',
      'Implementing cloud security best practices and IAM.',
      'Integrating AI/ML services with cloud infrastructure.',
      'Building a portfolio-ready capstone project.',
    ],
    benefits: [
      { title: 'LinkedIn Optimization', description: 'We help you craft a profile that stands out to recruiters.' },
      { title: 'Portfolio Building Help', description: 'Build real-world projects to showcase your skills.' },
      { title: 'Remote Job Guidance', description: 'Get tips and strategies for landing remote tech jobs.' },
      { title: 'Beginner-Friendly Training', description: 'Our curriculum is designed for those new to tech.' },
      { title: 'Certificate of Completion', description: 'Receive a certificate to validate your new skills.' },
    ],
    testimonials: [
      {
        name: 'Uche Ifeanyi',
        role: 'Cloud Enthusiast',
        quote: 'This course was a game-changer! I started with no cloud knowledge and now I feel confident navigating AWS. The hands-on projects were invaluable.',
        avatar: 'https://picsum.photos/100/100?random=1',
      },
      {
        name: 'Precious Chinedu',
        role: 'Data Analyst',
        quote: 'The instructors make complex topics like SQL and Power BI feel so simple. I went from zero to building insightful dashboards. Highly recommended for any aspiring data analyst!',
        avatar: 'https://picsum.photos/100/100?random=2',
      },
    ],
    curriculum: [
      { weeks: '1–2', title: 'Introduction to Cloud Computing', topics: ['Cloud concepts', 'Overview of AWS, GCP, Azure', 'Setting up your environment'] },
      { weeks: '3–4', title: 'Virtualization, Storage, and Networking', topics: ['Virtual Machines', 'Object and Block Storage', 'VPCs and Subnets'] },
      { weeks: '5–6', title: 'Deploying Applications', topics: ['Compute Services (EC2, GCE)', 'Database Services (RDS, Cloud SQL)', 'Storage Services (S3, GCS)'] },
      { weeks: '7–8', title: 'Cloud Security & IAM', topics: ['Identity and Access Management', 'Security groups and firewalls', 'Data encryption'] },
      { weeks: '9–10', title: 'Cloud + AI/ML Integration', topics: ['Using pre-trained models (e.g., SageMaker, Vertex AI)', 'Serverless functions'] },
      { weeks: '11–12', title: 'Capstone Project & Portfolio Development', topics: ['Building a scalable web application', 'CI/CD pipelines', 'Portfolio review'] },
    ],
  },
  {
    slug: 'data-science-ai',
    title: 'Data Science & AI',
    tagline: 'Master in 3 Months — Beginner-Friendly & Career-Oriented',
    price: '150,000',
    whatsAppLink: 'https://chat.whatsapp.com/JLL1QkZVSG77R2UVbtIJBI',
    paymentLink: 'https://paystack.shop/pay/data-science-ai',
    about: {
      duration: '3 months',
      format: 'Virtual',
      level: 'Beginner-friendly',
      platform: 'Telegram live',
      certificate: 'Certificate of Completion',
    },
    learnItems: [
      'Python programming for data science.',
      'Statistical analysis and probability.',
      'Machine Learning algorithms like regression and classification.',
      'Introduction to Deep Learning and Neural Networks.',
      'Natural Language Processing (NLP) techniques.',
      'Building end-to-end AI models.',
    ],
    benefits: [
      { title: 'LinkedIn Optimization', description: 'We help you craft a profile that stands out to recruiters.' },
      { title: 'Portfolio Building Help', description: 'Build real-world projects to showcase your skills.' },
      { title: 'Remote Job Guidance', description: 'Get tips and strategies for landing remote tech jobs.' },
      { title: 'Beginner-Friendly Training', description: 'Our curriculum is designed for those new to tech.' },
      { title: 'Certificate of Completion', description: 'Receive a certificate to validate your new skills.' },
    ],
    testimonials: [
      {
        name: 'Adanna Okoro',
        role: 'AI Beginner',
        quote: 'I started with zero coding knowledge and now I can build simple machine learning models. Incredible curriculum and support for a total beginner!',
        avatar: 'https://picsum.photos/100/100?random=3',
      },
      {
        name: 'Emeka Nwosu',
        role: 'Data Science Student',
        quote: 'The portfolio help was the best part. I had something to show for my learning, which made all the difference. Great for anyone starting out.',
        avatar: 'https://picsum.photos/100/100?random=4',
      },
    ],
    curriculum: [
      { weeks: '1–2', title: 'Python & Data Fundamentals', topics: ['Python basics', 'NumPy for numerical data', 'Pandas for data manipulation'] },
      { weeks: '3–4', title: 'Statistics & Data Visualization', topics: ['Descriptive and inferential statistics', 'Matplotlib and Seaborn', 'Storytelling with data'] },
      { weeks: '5–6', title: 'Machine Learning I', topics: ['Supervised learning (Regression, Classification)', 'Model evaluation', 'Scikit-learn'] },
      { weeks: '7–8', title: 'Machine Learning II', topics: ['Unsupervised learning (Clustering)', 'Ensemble methods (Random Forest, XGBoost)'] },
      { weeks: '9–10', title: 'Deep Learning & AI', topics: ['Introduction to Neural Networks with Keras/TensorFlow', 'Intro to NLP'] },
      { weeks: '11–12', title: 'Capstone Project & Career Prep', topics: ['End-to-end AI project', 'Deploying models', 'Interview practice'] },
    ],
  },
  {
    slug: 'data-analysis',
    title: 'Data Analysis',
    tagline: 'Master in 3 Months — Beginner-Friendly & Career-Oriented',
    price: '120,000',
    whatsAppLink: 'https://chat.whatsapp.com/D84Jn8XfhtADGFm9GnkgaH',
    paymentLink: 'https://paystack.shop/pay/data-analysis-basic',
    about: {
      duration: '3 months',
      format: 'Virtual',
      level: 'Beginner-friendly',
      platform: 'Telegram live',
      certificate: 'Certificate of Completion',
    },
    learnItems: [
      'Advanced techniques in Microsoft Excel.',
      'Querying databases using SQL.',
      'Creating interactive dashboards with Power BI or Tableau.',
      'Data cleaning and analysis using Python (Pandas).',
      'Communicating insights effectively.',
      'Building a comprehensive analytics portfolio.',
    ],
    benefits: [
      { title: 'LinkedIn Optimization', description: 'We help you craft a profile that stands out to recruiters.' },
      { title: 'Portfolio Building Help', description: 'Build real-world projects to showcase your skills.' },
      { title: 'Remote Job Guidance', description: 'Get tips and strategies for landing remote tech jobs.' },
      { title: 'Beginner-Friendly Training', description: 'Our curriculum is designed for those new to tech.' },
      { title: 'Certificate of Completion', description: 'Receive a certificate to validate your new skills.' },
    ],
    testimonials: [
      {
        name: 'Fatima Bello',
        role: 'Aspiring Data Analyst',
        quote: 'From Excel novice to building complex dashboards in Power BI, this course covered everything. The practical skills are immediately applicable.',
        avatar: 'https://picsum.photos/100/100?random=5',
      },
      {
        name: 'David Adebayo',
        role: 'Data Enthusiast',
        quote: 'The SQL module was fantastic. I finally understand how to get the data I need. The instructors make complex topics easy to grasp for a beginner.',
        avatar: 'https://picsum.photos/100/100?random=6',
      },
    ],
    curriculum: [
      { weeks: '1–2', title: 'Advanced Excel for Data Analysis', topics: ['PivotTables', 'VLOOKUP/XLOOKUP', 'Data cleaning functions'] },
      { weeks: '3–4', title: 'SQL for Data Extraction', topics: ['SELECT statements', 'JOINs', 'Aggregations and Grouping'] },
      { weeks: '5–6', title: 'Data Visualization I', topics: ['Introduction to Power BI/Tableau', 'Building your first dashboard'] },
      { weeks: '7–8', title: 'Data Visualization II', topics: ['Advanced dashboarding techniques', 'Calculated fields and DAX', 'Data storytelling'] },
      { weeks: '9–10', title: 'Python for Data Analysis', topics: ['Introduction to Pandas', 'Data manipulation and cleaning with Python'] },
      { weeks: '11–12', title: 'Final Project & Portfolio', topics: ['Analyzing a large dataset from start to finish', 'Presenting findings'] },
    ],
  },
  {
    slug: 'cyber-security',
    title: 'Cyber Security & Ethical Hacking',
    tagline: 'Master in 3 Months — Beginner-Friendly & Career-Oriented',
    price: '200,000',
    whatsAppLink: 'https://chat.whatsapp.com/E9sHnXACNTf7K0mIeyt4Sv',
    paymentLink: 'https://paystack.shop/pay/cybersecurity-hacking',
    about: {
      duration: '3 months',
      format: 'Virtual',
      level: 'Beginner-friendly',
      platform: 'Telegram live',
      certificate: 'Certificate of Completion',
    },
    learnItems: [
      'Core networking and system administration principles.',
      'Fundamentals of cryptography and data protection.',
      'Identifying and mitigating common web application vulnerabilities.',
      'Hands-on experience with ethical hacking tools like Metasploit and Nmap.',
      'Performing penetration tests in a controlled environment.',
      'Understanding incident response and forensics.',
    ],
    benefits: [
      { title: 'LinkedIn Optimization', description: 'We help you craft a profile that stands out to recruiters.' },
      { title: 'Portfolio Building Help', description: 'Build real-world projects to showcase your skills.' },
      { title: 'Remote Job Guidance', description: 'Get tips and strategies for landing remote tech jobs.' },
      { title: 'Beginner-Friendly Training', description: 'Our curriculum is designed for those new to tech.' },
      { title: 'Certificate of Completion', description: 'Receive a certificate to validate your new skills.' },
    ],
    testimonials: [
      {
        name: 'Aisha Musa',
        role: 'Security Enthusiast',
        quote: 'The hands-on labs were the best part. I went from theory to practice, which prepared me for real-world challenges even as a beginner.',
        avatar: 'https://picsum.photos/100/100?random=7',
      },
      {
        name: 'Oluwaseun Adekunle',
        role: 'Ethical Hacking Student',
        quote: 'RiteClick provided the perfect foundation for my career in security. The instructors are knowledgeable and always ready to help.',
        avatar: 'https://picsum.photos/100/100?random=8',
      },
    ],
    curriculum: [
      { weeks: '1–2', title: 'Foundations of Networking & Linux', topics: ['TCP/IP model', 'Linux command line', 'User and permission management'] },
      { weeks: '3–4', title: 'Introduction to Cyber Security', topics: ['CIA Triad', 'Common threats and vulnerabilities', 'Security policies'] },
      { weeks: '5–6', title: 'Cryptography and Access Control', topics: ['Symmetric/Asymmetric encryption', 'Hashing', 'Authentication vs. Authorization'] },
      { weeks: '7–8', title: 'Web Application Security', topics: ['OWASP Top 10', 'SQL Injection, XSS', 'Secure coding practices'] },
      { weeks: '9–10', title: 'Ethical Hacking & Tools', topics: ['Reconnaissance (Nmap)', 'Exploitation (Metasploit)', 'Reporting'] },
      { weeks: '11–12', title: 'Capstone: Live Penetration Test', topics: ['Conducting a full pentest on a target environment', 'Documenting findings'] },
    ],
  },
];
